function VMT_ExportPNG(path,fignum,BkgdColor,AxColor,FigColor,FntSize,Res)

%This script exports the given figure and formats it according to the
%specified properties:

%BkgdColor: Background Color (outside of figure space)
%AxColor:   Axes Color 
%FigColor:  Figure window color (inside figure Space)
%FntSize:   Fontsize for axes labels and title

%P.R. Jackson, USGS, 12-14-08

figure(fignum); 
set(gcf, 'PaperPositionMode', 'auto');
box on
if ~isempty(BkgdColor)
    set(gcf,'Color',BkgdColor);
end

if ~isempty(FntSize)
    set(gca,'FontSize',FntSize)
    set(get(gca,'Title'),'FontSize',FntSize) 
end

if ~isempty(FigColor)
    set(gca,'Color',FigColor)
end

if ~isempty(AxColor)
    set(gca,'XColor',AxColor)
    set(gca,'YColor',AxColor)
    set(gca,'ZColor',AxColor)
    set(findobj(gcf,'tag','Colorbar'),'FontSize',FntSize,'XColor',AxColor,'YColor',AxColor);
    set(get(gca,'Title'),'FontSize',FntSize,'Color',AxColor) 
end

set(gcf,'InvertHardCopy','off')

%Save the figure

[file,path] = uiputfile('*.png','Save file name')
fileout = [path file];
%fileout = [path '_Figure' num2str(fignum)];
disp(fileout)
set(gcf, 'PaperPositionMode', 'auto');
print(['-f' num2str(fignum)],'-dpng', '-noui', '-painters',['-r' num2str(Res)],fileout)



