function [A] = VMT_MBBathy(z,A,savefile,beamAng,magVar,wse)

%This routine computes the multibeam bathymetry from the four beams of the ADCP 
%using a script by D.Mueller (USGS). Beam depths are computed for each
%transect prior to any averaging or mapping.

%P.R. Jackson, USGS, 12-9-08 

%% Start 
disp('Computing corrected beam depths')

%% Step through each transect in the given set

for zi = 1 : z
    
    % Compute position and elevation of each beam depth
    [exyz] = depthxyz(A(zi).Nav.depth,A(zi).Sup.draft_cm,...
        A(zi).Sensor.pitch_deg,A(zi).Sensor.roll_deg,....
        A(zi).Sensor.heading_deg,beamAng,magVar,...
        'm',A(zi).Comp.xUTMraw,A(zi).Comp.yUTMraw,wse,A(zi).Sup.ensNo);

    % Store results    
    idxmbb = find(~isnan(exyz(:,4))& ~isnan(exyz(:,2)));
    if zi==1
        zmbb=[exyz(idxmbb,1) exyz(idxmbb,2)...
            exyz(idxmbb,3) exyz(idxmbb,4)];
    else
        zmbb=cat(1,zmbb,[exyz(idxmbb,1)...
            exyz(idxmbb,2) exyz(idxmbb,3) exyz(idxmbb,4)]);
    end
      
    A(zi).Comp.exyz = exyz(idxmbb,:);
    
        
    clear idxmbb exyz;
    %pack;
end


%% Save the data

if 1
    disp('Exporting multibeam bathymetry')
    disp([savefile(1:end-4) '_mbxyz.csv'])
    dlmwrite([savefile(1:end-4) '_mbxyz.csv'],zmbb,'precision',15);
end