function [A] = VMT_MBBathyV2(z,A,savefile,beamAng,magVar,wse,saveaux)

%This routine computes the multibeam bathymetry from the four beams of the ADCP 
%using a script by D.Mueller (USGS). Beam depths are computed for each
%transect prior to any averaging or mapping.

%V2 adds the ability to export timestamps, pitch, roll, and heading
%(2/1/10)

%P.R. Jackson, USGS, 12-9-08 

%% Start 
disp('Computing corrected beam depths')

%% Step through each transect in the given set

for zi = 1 : z
    
    % Compute position and elevation of each beam depth
    [exyz] = depthxyz(A(zi).Nav.depth,A(zi).Sup.draft_cm,...
        A(zi).Sensor.pitch_deg,A(zi).Sensor.roll_deg,....
        A(zi).Sensor.heading_deg,beamAng,...
        'm',A(zi).Comp.xUTMraw,A(zi).Comp.yUTMraw,wse,A(zi).Sup.ensNo);  %magVar,removed 4-8-10
    
    %Build the auxillary data matrix
    if saveaux
        auxmat = [A(zi).Sup.year+2000 A(zi).Sup.month A(zi).Sup.day...
                A(zi).Sup.hour A(zi).Sup.minute (A(zi).Sup.second+A(zi).Sup.sec100./100) ...
                A(zi).Sensor.heading_deg A(zi).Sensor.pitch_deg A(zi).Sensor.roll_deg];    %Had to add 2000 to year--will not work for years < 2000
        auxmat2 = []; 
        for i = 1:length(A(zi).Sup.ensNo); 
            dum = repmat(auxmat(i,:),4,1); 
            auxmat2 = cat(1,auxmat2,dum); 
        end
        clear auxmat dum
    end
    
    % Store results    
    idxmbb = find(~isnan(exyz(:,4))& ~isnan(exyz(:,2)));
    if zi==1
        zmbb=[exyz(idxmbb,1) exyz(idxmbb,2)...
            exyz(idxmbb,3) exyz(idxmbb,4)];
        if saveaux
            auxmbb = auxmat2(idxmbb,:);
        end
    else
        zmbb=cat(1,zmbb,[exyz(idxmbb,1)...
            exyz(idxmbb,2) exyz(idxmbb,3) exyz(idxmbb,4)]);
        if saveaux
            auxmbb = cat(1,auxmbb,auxmat2(idxmbb,:));
        end
    end
      
    A(zi).Comp.exyz = exyz(idxmbb,:);
    
        
    clear idxmbb exyz;
    %pack;
end


%% Save the data

if 1
    disp('Exporting multibeam bathymetry')
    disp([savefile(1:end-4) '_mbxyz.csv'])
    outfile = [savefile(1:end-4) '_mbxyz.csv'];
    if saveaux
        outmat = [zmbb auxmbb];
        ofid   = fopen(outfile, 'wt');
        outcount = fprintf(ofid,'EnsNo,     Easting_WGS84_m,    Northing_WGS84_m,  Elev_m,  Year,  Month,  Day,  Hour,  Minute,  Second,  Heading_deg,  Pitch_deg,  Roll_deg\n');
        outcount = fprintf(ofid,'%6.0f, %14.2f, %14.2f, %8.2f, %4.0f, %2.0f, %2.0f, %2.0f, %2.0f, %2.2f, %3.3f, %3.3f, %3.3f\n',outmat');
        fclose(ofid);
    else
        outmat = zmbb;
        ofid   = fopen(outfile, 'wt');
        outcount = fprintf(ofid,'EnsNo,     Easting_WGS84_m,    Northing_WGS84_m,  Elev_m\n');
        outcount = fprintf(ofid,'%6.0f, %14.2f, %14.2f, %8.2f\n',outmat');
        fclose(ofid);
    end
    %dlmwrite([savefile(1:end-4) '_mbxyz.csv'],outmat,'precision',15);   
end