function [A,V] = VMT_MapEns2MeanXSV2(z,A,setends)

%This routine fits multiple transects at a single location with a single
%line and maps individual ensembles to this line. Inputs are number of files (z) and data matrix (Z)(see ReadFiles.m).
%Output is the updated data matrix with new mapped variables. 

%V2 adds the capability to set the endpoints of the mean cross section

%(adapted from code by J. Czuba)

%P.R. Jackson, USGS, 12-9-08 



%% Determine the best fit mean cross-section line from multiple transects
% initialize vectors for concatenation

x = [];
y = [];
figure(1); clf
set(gca,'DataAspectRatio',[1 1 1],'PlotBoxAspectRatio',[1 1 1])
for zi = 1 : z
    
    % concatenate coords into a single column vector for regression
    x=cat(1,x,A(zi).Comp.xUTM);
    y=cat(1,y,A(zi).Comp.yUTM);

    figure(1); hold on
    %plot(A(zi).Comp.xUTM,A(zi).Comp.yUTM,'r'); hold on
    plot(A(zi).Comp.xUTMraw,A(zi).Comp.yUTMraw,'b'); hold on
    
    %Find the mean flow direction for each transect
    mfd(zi) = nanmean(nanmean(A(zi).Clean.vDir,1)); 
          
end

if setends  %Gets a user text file with fixed cross section end points 
    
        defaultpath = 'C:\';
        endspath = [];
        if exist('\VMT\LastDir.mat') == 2
            load('\VMT\LastDir.mat');
            if exist(endspath) == 7
                [file,endspath] = uigetfile({'*.txt;*.csv','All Text Files'; '*.*','All Files'},'Select Endpoint Text File',endspath);       
            else
                [file,endspath] = uigetfile({'*.txt;*.csv','All Text Files'; '*.*','All Files'},'Select Endpoint Text File',defaultpath);
            end
        else
            [file,endspath] = uigetfile({'*.txt;*.csv','All Text Files'; '*.*','All Files'},'Select Endpoint Text File',defaultpath);
        end
        infile = [endspath file];
        %[file,path] = uigetfile({'*.txt;*.csv','All Text Files'; '*.*','All Files'},'Select Endpoint Text File');
        %infile = [path file];
        disp('Loading Endpoint File...' );
        disp(infile);
        data = dlmread(infile);
        x = data(:,1);
        y = data(:,2);
        figure(1); hold on
        plot(x,y,'go','MarkerSize',10); hold on
end

V.mfd = nanmean(mfd); % Mean flow direction for all the transects

% find the equation of the best fit line 
xrng = max(x) - min(x);
yrng = max(y) - min(y);

if xrng >= yrng %Fit based on coordinate with larger range of values (original fitting has issues with N-S lines because of repeated X values), PRJ 12-12-08
    [P,S] = polyfit(x,y,1);
    figure(1); hold on; 
    plot(x,polyval(P,x),'g-')
    V.m = P(1);
    V.b = P(2);
else
    [P,S] = polyfit(y,x,1);
    figure(1); hold on; 
    plot(polyval(P,y),y,'g-')
    V.m = 1/P(1);           %Reformat slope and intercept in terms of y= fn(x) rather than x = fn(y)
    V.b = -P(2)/P(1);
end

%Former method commented out
% whichstats = {'tstat','yhat'};
% stats = regstats(y,x,'linear', whichstats);
% 
% % mean cross-section line slope and intercept
% V.m = stats.tstat.beta(2);
% V.b = stats.tstat.beta(1);

clear x y stats whichstats zi

%% Map ensembles to mean c-s line
% Determine the point (mapped ensemble point) where the equation of the 
% mean cross-section line intercepts a line perpendicular to the mean
% cross-section line passing through an ensemble from an individual
% transect (see notes for equation derivation)

for zi = 1 : z
    
    A(zi).Comp.xm = ((A(zi).Comp.xUTM-V.m.*V.b+V.m.*A(zi).Comp.yUTM)...
        ./(V.m.^2+1));
    A(zi).Comp.ym = ((V.b+V.m.*A(zi).Comp.xUTM+V.m.^2.*A(zi).Comp.yUTM)...
        ./(V.m.^2+1));
    
end


%Plot data to check
xensall = [];
yensall = [];
for zi = 1 : z
  plot(A(zi).Comp.xm,A(zi).Comp.ym,'b.')
  xensall = [xensall; A(zi).Comp.xm];
  yensall = [yensall; A(zi).Comp.ym];
end
% plot(A(3).Comp.xm,A(3).Comp.ym,'xg')
% plot(A(4).Comp.xm,A(4).Comp.ym,'oy')
xlabel('UTM Easting (m)')
ylabel('UTM Northing (m)')
box on
grid on
%Plot a legend in Figure 1
%figure(1); hold on
%legend('Shoreline','GPS(corr)','GPS(raw)','Best Fit','Trans 1
%(mapped)','Other Trans (mapped)')

%Compute the median distance between mapped points
Dmat = [xensall yensall];
if xrng > yrng
    Dmat = sortrows(Dmat,1);
else
    Dmat = sortrows(Dmat,2);
end
dxall = diff(Dmat(:,1));
dyall = diff(Dmat(:,2));
densall = sqrt(dxall.^2 + dyall.^2);
V.meddens = median(densall);
V.stddens = std(densall);
disp(['Median Spacing Between Mapped Ensembles = ' num2str(V.meddens) ' m'])
disp(['Standard Deviation of Spacing Between Mapped Ensembles = ' num2str(V.stddens) ' m'])
disp(['Recommended Grid Node Spacing > ' num2str(V.meddens + V.stddens) ' m'])

%Display in message box for compiled version
msg_string = {['Median Spacing Between Mapped Ensembles = ' num2str(V.meddens) ' m'],...
    ['Standard Deviation of Spacing Between Mapped Ensembles = ' num2str(V.stddens) ' m'],...
    ['Recommended Grid Node Spacing > ' num2str(V.meddens + V.stddens) ' m']};
msgbox(msg_string,'VMT Grid Node Spacing','help','replace');

%%Save the shorepath
if setends
    if exist('LastDir.mat') == 2
        save('LastDir.mat','endspath','-append')
    else
        save('LastDir.mat','endspath')
    end
end


