function VMT_SaveFigs(path,fignums,figformat)

%This routine saves the figures (specified by fignums) from VMT as .PNG
%files (300 dpi).

%P.R. Jackson, USGS, 2-10-09

%figformat = 0;  %Set to 1 for print version, otherwise, set to zero for presentation version

disp('{Saving Figures...')
if figformat
    disp('Figure Format: Print')
else
    disp('Figure Format: Presentation')
end
for i = fignums
    disp(['Figure ' num2str(i)])
    if i == 1
        VMT_ExportPNG(path,i,'w','k','w',14,300);  %Figure 1 default is white background and figure space, black axes, 14 point fonts
    else
        if figformat
            VMT_ExportPNG(path,i,'w','k',[0.3 0.3 0.3],14,300);
            %VMT_ExportPNG(path,i,[0.2 0.2 0.2],'w',[0.3 0.3 0.3],14,300);  %default is black background and figure space, white axes, 14 point fonts
        else
            VMT_ExportPNG(path,i,'k','w',[0.3 0.3 0.3],14,300);
        end
    end
end
disp('Saving Figures Complete')

